package openrtb3

import "encoding/json"

type Site struct {
	ID      string          `json:"id,omitempty"`
	Name    string          `json:"name,omitempty"`
	Cat     []string        `json:"cat,omitempty"`        // Array of IAB content categories
	PageCat []string        `json:"pagecat,omitempty"`    // Array of IAB content categories
	SecCat  []string        `json:"sectioncat,omitempty"` // Array of IAB content categories
	Domain  string          `json:"domain,omitempty"`
	Mobile  int             `json:"mobile,omitempty"`
	Amp     int             `json:"amp,omitempty"`
	Page    string          `json:"page,omitempty"`
	RefPage string          `json:"ref,omitempty"`
	Pub     *Publisher      `json:"pub,omitempty"`
	Ext     json.RawMessage `json:"ext,omitempty"`
}

// Abstract third-party
type ThirdParty struct {
	ID     string          `json:"id,omitempty"`
	Name   string          `json:"name,omitempty"`
	Cat    []string        `json:"cat,omitempty"` // Array of IAB content categories
	Domain string          `json:"domain,omitempty"`
	Ext    json.RawMessage `json:"ext,omitempty"`
}

// The publisher object itself and all of its parameters are optional, so default values are not
// provided. If an optional parameter is not specified, it should be considered unknown.
type Publisher ThirdParty
